﻿using Ozeki.VoIP;

namespace VoiceMail
{
    class MyDialplanProvider : IDialplanProvider
    {
        UserInfoContainer userInfoContainer;
        IExtensionContainer extensionContainer;

        public MyDialplanProvider(UserInfoContainer userInfoContainer, IExtensionContainer extensionContainer)
        {
            this.userInfoContainer = userInfoContainer;
            this.extensionContainer = extensionContainer;
        }

        #region IDialplanProvider Members

        public string Name
        {
            get { return "CustomDialplan"; }
        }

        public IDialplanResult GetDestination(RouteInfo routeInfo)
        {
            var currentDialed = routeInfo.DialInfo.Dialed;

            // if dialed number was busy or not answered, hang up call
            if (routeInfo.State != RoutingState.Calling)
            {
                UserInfo userInfo;
                if (userInfoContainer.TryGetUserInfo(currentDialed, out userInfo))
                {
                    var destination = new Destination(MyPBX.VoiceMailNumber);
                    destination.AddAdditionalParameter("voicemailtarget", currentDialed);
                    return destination;
                }

                return null;
            }

            // if "200" dialed, ring the first available extension
            if (currentDialed == "200")
            {
                var userInfos = userInfoContainer.GetUserInfos();
                foreach (var userInfo in userInfos)
                {
                    // skip the caller extension
                    if (userInfo.UserName == routeInfo.SourceExtension.ExtensionID)
                        continue;

                    var extension = extensionContainer.GetExtension(userInfo.UserName);
                    if (extension != null)
                        return new Destination(extension.ExtensionID);
                }

                return null;
            }

            return new Destination(currentDialed);
        }

        public SessionMode GetSessionMode(IBaseCall caller, IBaseCall callee, SessionMode defaultSessionMode)
        {
            return defaultSessionMode;
        }

        #endregion
    }
}
