﻿using System;
using System.Diagnostics;
using System.IO;
using Ozeki.Network;
using Ozeki.VoIP;
using VoiceMail.VoiceMail;

namespace VoiceMail
{
    class MyPBX : PBXBase
    {
        public static string VoiceMailNumber = "800";

        string localAddress;
        UserInfoContainer userInfoContainer;

        public MyPBX(string localAddress, int minPortRange, int maxPortRange) : base(minPortRange, maxPortRange)
        {
            Console.WriteLine("PBX starting...");
            Console.WriteLine("Local address: " + localAddress);

            this.localAddress = localAddress;
            SetUserInfos();
        }

        protected override AuthenticationResult OnAuthenticationRequest(ISIPExtension extension, RequestAuthenticationInfo authInfo)
        {
            Console.WriteLine("Authentication request received from: " + extension.ExtensionID);

            AuthenticationResult result = new AuthenticationResult();

            UserInfo userInfo;
            if (userInfoContainer.TryGetUserInfo(extension.ExtensionID, out userInfo))
            {
                result = extension.CheckPassword(userInfo.UserName, userInfo.Password, authInfo);
            }
            else
            {
                Console.WriteLine("Cannot find extension. UserName: " + extension.ExtensionID);
            }

            if (result.AuthenticationAccepted)
            {
                Console.WriteLine("Authentication accepted. UserName: " + extension.ExtensionID);
            }
            else
            {
                Console.WriteLine("Authentication failed. UserName: " + extension.ExtensionID);
            }

            return result;
        }

        protected override void OnStart()
        {
            SetDialplanProvider();
            SetListenedPort();

            InitVoiceMail();

            Console.WriteLine("PBX started.");
            base.OnStart();
        }

        private void SetListenedPort()
        {
            SetListenPort(localAddress, 5060, TransportType.Udp);
            Console.WriteLine("Listened port: 5060(UDP)");
        }

        protected override RegisterResult OnRegisterReceived(ISIPExtension extension, SIPAddress from, int expires)
        {
            Console.WriteLine("Register received from: " + extension.ExtensionID);
            return base.OnRegisterReceived(extension, from, expires);
        }

        protected override void OnUnregisterReceived(ISIPExtension extension)
        {
            Console.WriteLine("Unregister received from: " + extension.ExtensionID);
            base.OnUnregisterReceived(extension);
        }

        protected override void OnCallRequestReceived(ISessionCall call)
        {
            Console.WriteLine("Call request received. Caller: " + call.DialInfo.CallerID + " callee: " + call.DialInfo.Dialed);
            base.OnCallRequestReceived(call);
        }

        private void SetUserInfos()
        {
            userInfoContainer = new UserInfoContainer();

            for (int i = 0; i < 10; i++)
            {
                var userName = string.Format("85{0}", i);
                var password = userName;

                userInfoContainer.AddUserInfo(new UserInfo(userName, password));
            }
        }

        void InitVoiceMail()
        {
            var callManager = GetService<ICallManager>();
            var extensionContainer = GetService<IExtensionContainer>();

            var rootPath = Path.GetDirectoryName(Process.GetCurrentProcess().MainModule.FileName);
            var voiceMailRootPath = Path.Combine(rootPath, "Records");

            var voiceMailExtension = new VoiceMailExtension(VoiceMailNumber, callManager, voiceMailRootPath);
            extensionContainer.TryAddExtension(voiceMailExtension);
        }

        void SetDialplanProvider()
        {
            var callManager = GetService<ICallManager>();
            var extensionContainer = GetService<IExtensionContainer>();
            callManager.DialplanProvider = new MyDialplanProvider(userInfoContainer, extensionContainer);
        }
    }
}
