﻿using System;
using System.Collections.Generic;

namespace VoiceMail
{
    class UserInfoContainer
    {
        Dictionary<string, UserInfo> allowedUsers;

        public UserInfoContainer()
        {
            allowedUsers = new Dictionary<string, UserInfo>();
        }

        public void AddUserInfo(UserInfo userInfo)
        {
            if (allowedUsers.ContainsKey(userInfo.UserName))
                throw new InvalidOperationException("User already configured");

            allowedUsers.Add(userInfo.UserName, userInfo);
        }

        public IEnumerable<UserInfo> GetUserInfos()
        {
            return allowedUsers.Values;
        }

        public bool TryGetUserInfo(string userName, out UserInfo userInfo)
        {
            return allowedUsers.TryGetValue(userName, out userInfo);
        }
    }
}
