﻿using System;
using Ozeki.VoIP;

namespace VoiceMail.VoiceMail
{
    class VoiceMailCallHandler
    {
        IPBXCall call;
        IVoiceMailCommand voiceMailCommand;
        ICallManager callManager;
        string target;
        string voiceMailRootPath;

        public VoiceMailCallHandler(IPBXCall pbxCall, string target, string voiceMailRootPath, ICallManager callManager)
        {
            this.voiceMailRootPath = voiceMailRootPath;
            this.callManager = callManager;
            this.target = target;

            call = pbxCall;
            call.CallStateChanged += call_CallStateChanged;
        }

        public event EventHandler Completed;

        void call_CallStateChanged(object sender, CallStateChangedArgs e)
        {
            if (e.State == CallState.Ringing)
            {
                var other = callManager.SessionContainer.GetOtherCall(call);
                if (other == null)
                {
                    call.HangUp();
                    return;
                }

                var caller = other.Owner.ExtensionID;

                if (target != null)
                {
                    voiceMailCommand = new VoiceMailRecordCommand(call, voiceMailRootPath, target, caller);
                    voiceMailCommand.Completed += ActionCompleted;
                }
                else
                {
                    voiceMailCommand = new VoiceMailPlayCommand(call, voiceMailRootPath, caller);
                    voiceMailCommand.Completed += ActionCompleted;
                }

                voiceMailCommand.Execute();
            }
        }

        void ActionCompleted(object sender, EventArgs e)
        {
            var handler = Completed;
            if (handler != null)
                handler(this, EventArgs.Empty);
        }
    }
}
