﻿using System;
using System.Collections.Generic;
using Ozeki.VoIP;

namespace VoiceMail.VoiceMail
{
    class VoiceMailExtension : IExtension
    {
        List<VoiceMailCallHandler> voiceMailCallHandlers;
        ICallManager callManager;
        string voiceMailRootPath;

        public VoiceMailExtension(string id, ICallManager callManager, string voiceMailRootPath)
        {
            ExtensionID = id;
            this.callManager = callManager;
            this.voiceMailRootPath = voiceMailRootPath;

            voiceMailCallHandlers = new List<VoiceMailCallHandler>();
        }

        void HandlerCompleted(object sender, EventArgs e)
        {
            var voiceMailCallHandler = (VoiceMailCallHandler)sender;
            voiceMailCallHandlers.Remove(voiceMailCallHandler);
        }

        public string ExtensionID { get; private set; }

        public string Type
        {
            get { return "VoiceMail"; }
        }

        public void OnCalled(IPBXCall call, IncomingCallParams callParams)
        {
            string target = null;
            if (callParams.AdditionalParameters.ContainsKey("voicemailtarget"))
                target = callParams.AdditionalParameters["voicemailtarget"];

            var voiceMailCallHandler = new VoiceMailCallHandler(call, target, voiceMailRootPath, callManager);

            voiceMailCallHandlers.Add(voiceMailCallHandler);
            voiceMailCallHandler.Completed += HandlerCompleted;
        }

        public void OnMessageReceived(Message message)
        {
        }        
    }
}
