﻿using System;
using System.Collections.Generic;
using System.Threading;
using Ozeki.Media;
using Ozeki.VoIP;

namespace _11_RingGroup
{
    class Program
    {
        static List<RingGroupCallHandler> _callHandlers;
        static List<string> _members;
        static int _memberCount;
        static Softphone _softphone;

        static void Main(string[] args)
        {
            _softphone = new Softphone();

            ShowHelp();

            SipAccountInitialization(_softphone);

            _callHandlers = new List<RingGroupCallHandler>();

            _softphone.IncomigCall += softphone_IncomigCall;
            _softphone.PhoneLineStateChanged += softphone_PhoneLineStateChanged;
            

            BlockExit();
        }

        static void softphone_PhoneLineStateChanged(object sender, RegistrationStateChangedArgs e)
        {
            Console.WriteLine("Phone line state changed to: {0}", e.State);

            if (e.State == RegState.RegistrationSucceeded)
                MemberAdder();
        }


        static void MemberAdder()
        {
            _members = new List<string>();

            while (_memberCount == 0)
            {
                Console.Write("\nThe number of the RingGroup members: ");
                try
                {
                    _memberCount = int.Parse(Console.ReadLine());
                }
                catch
                {
                    Console.WriteLine("Wrong input!");
                }
            }

            for (int i = 0; i < _memberCount; i++)
            {
                Console.Write("{0}. member's phone number: ", i+1);
                string member = Console.ReadLine();
                _members.Add(member);
            }

            Console.WriteLine("\nWaiting for incoming calls...");
        }


        static void ShowHelp()
        {
            Console.WriteLine("This is a simple Ozeki VoIP SIP SDK demo written in C#.");
            Console.WriteLine("This example is about to introduce the creation of a RingGroup (with the RingAll strategy), which works on the following way:");
            Console.WriteLine("1., the application asks the user about the number of the RingGroup members");
            Console.WriteLine("2., also asks the user, to enter the members' phone numbers");
            Console.WriteLine("3., waits for an incoming call");
            Console.WriteLine("4., starts to ring all of the RingGroup members");
            Console.WriteLine("5., if the call is being answered, it transfers the call and stops ringing the other members");
            Console.WriteLine("-------------------------------------------------------------------------------");
            Console.WriteLine();
        }

        static void softphone_IncomigCall(object sender, VoIPEventArgs<IPhoneCall> e)
        {
            Console.WriteLine("\nIncoming call from \"{0}\"!\n", e.Item.DialInfo.CallerDisplay);

            var callHandler = new RingGroupCallHandler(e.Item, _softphone, _members);
            callHandler.Completed += callHandler_Completed;

            lock (_callHandlers)
                _callHandlers.Add(callHandler);

            callHandler.Start();
        }


        static void callHandler_Completed(object sender, EventArgs e)
        {
            lock (_callHandlers)
                _callHandlers.Remove((RingGroupCallHandler) sender);
        }

        static void SipAccountInitialization(Softphone softphone)
        {
            
            var registrationRequired = true;
            Console.WriteLine("\nPlease set up Your SIP account:\n");

            // Asks, if a registration is required to the PBX. The default value is true.
            Console.Write("Please set if the registration is required (true/false) (default: true): ");
            var regRequired = Read("Registration required", false);
            if (regRequired.ToLower() == "false" || regRequired.ToLower() == "no" ||
                 regRequired.ToLower() == "n")
            {
                registrationRequired = false;
            }
            else
            {
                Console.WriteLine("Registration set to required.");
            }


            // The SIP account needs and authentication ID, and some names as well.
            Console.Write("Please set Your authentication ID: ");
            var authenticationId = Read("Authentication ID", true);

            // If the user only presses the Enter button, the username will be the same as the authentication ID
            Console.Write("Please set Your username (default: " + authenticationId + "): ");
            var userName = Read("Username", false);
            if (string.IsNullOrEmpty(userName))
                userName = authenticationId;

            // If the user only presses the Enter button, the display name will be the same as the authentication ID
            Console.Write("Please set Your name to be displayed (default: " + authenticationId + "): ");
            var displayName = Read("Display name", false);
            if (string.IsNullOrEmpty(displayName))
                displayName = authenticationId;

            // The registration password needs to be entered.
            Console.Write("Please set Your registration password: ");
            var registerPassword = Read("Password", true);

            // Domain name as a string, for example an IP adress.
            Console.Write("Please set the domain name: ");
            var domainHost = Read("Domain name", true);

            // Port number with the as 5060 default value.
            Console.Write("Please set the port number (default: 5060): ");
            int domainPort;
            string port = Read("Port", false);
            if (string.IsNullOrEmpty(port))
            {
                domainPort = 5060;
            }
            else
            {
                domainPort = Int32.Parse(port);
            }
            Console.WriteLine("\nCreating SIP account and trying to register....\n");


            Console.WriteLine("\nCreating SIP account and trying to register...\n");
            softphone.Register(registrationRequired, displayName, userName, authenticationId, registerPassword, domainHost, domainPort);

        }

        static string Read(string inputName, bool readWhileEmpty)
        {
            while (true)
            {
                string input = Console.ReadLine();

                if (!readWhileEmpty)
                {
                    return input;
                }

                if (!string.IsNullOrEmpty(input))
                {
                    return input;
                }

                Console.WriteLine(inputName + " cannot be empty!");
                Console.WriteLine(inputName + ": ");
            }
        }

        static void BlockExit()
        {
            while (true)
            {
                Thread.Sleep(10);
            }
        }
    }
}
