﻿using System;
using Ozeki.Media;
using Ozeki.VoIP;

namespace _11_RingGroup
{
    class Softphone
    {
        ISoftPhone _softphone;
        IPhoneLine _phoneLine;

        public event EventHandler<VoIPEventArgs<IPhoneCall>> IncomigCall;
        public event EventHandler<RegistrationStateChangedArgs> PhoneLineStateChanged;

        public Softphone()
        {
            _softphone = SoftPhoneFactory.CreateSoftPhone(5000, 10000);
            _softphone.IncomingCall += softphone_IncomingCall;
        }


        public void Register(bool registrationRequired, string displayName, string userName, string authenticationId, string registerPassword, string domainHost, int domainPort)
        {
            try
            {
                var account = new SIPAccount(registrationRequired, displayName, userName, authenticationId, registerPassword, domainHost, domainPort);
                Console.WriteLine("\nCreating SIP account {0}", account);
                
                _phoneLine = _softphone.CreatePhoneLine(account);
                Console.WriteLine("Phoneline created.");

                _phoneLine.RegistrationStateChanged += _phoneLine_RegistrationStateChanged;

                _softphone.RegisterPhoneLine(_phoneLine);
            }
            catch(Exception ex)
            {
                Console.WriteLine("Error during SIP registration" + ex);
            }
        }

        void _phoneLine_RegistrationStateChanged(object sender, RegistrationStateChangedArgs e)
        {
            var handler = PhoneLineStateChanged;
            if (handler != null)
                handler(this, e);
        }
        
        void softphone_IncomingCall(object sender, VoIPEventArgs<IPhoneCall> e)
        {
            var handler = IncomigCall;
            if (handler != null)
                handler(this, e);
        }

        public IPhoneCall CreateCall(string member)
        {
            return _softphone.CreateCallObject(_phoneLine, member);
        }
    }
}
